function lap_kelompok(editor, semester) {
	var lap =
	{
		type: 'menuitem',
		text: 'Laporan Keuangan (Belanja per Kelompok)-Impor-Semester ' + semester,
		icon: 'table',
		onAction: function () {
			var url = BASE_URL + "index.php/keuangan/cek_tahun";

			$.ajax({
				type: "GET",
				url: url,
				dataType: "json",
				processData: true,
				success: function (data) {

					editor.windowManager.open({

						title: 'Tahun Anggaran',
						body: {
							type: 'panel',
							items: [
								{
									type: 'selectbox',
									name: 'tahun',
									label: 'Pilih Tahun Anggaran',
									items: data
								},
							]
						},
						buttons: [
							{
								type: 'cancel',
								text: 'Tutup'
							},
							{
								type: 'submit',
								text: 'Pilih',
								primary: true
							}
						],

						onSubmit: function (api) {
							var data = api.getData();
							editor.insertContent('[[lap-RP-APBD-sm' + semester + ',' + data.tahun + ']]');
							api.close();
						},

						width: 400,
						height: 140
					})
				},

				error: function (xhr, status, error) {
					alert("Error! " + xhr.status + "\n" + error);
					console.log(xhr);
				}
			});
		}
	};
	return lap;
};

function lap_bidang(editor, semester) {
	var lap =
	{
		type: 'menuitem',
		text: 'Laporan Keuangan (Belanja per Bidang)-Impor-Semester ' + semester,
		icon: 'table',
		onAction: function () {
			var url = BASE_URL + "index.php/keuangan/cek_tahun";

			$.ajax({
				type: "GET",
				url: url,
				dataType: "json",
				processData: true,
				success: function (data) {

					editor.windowManager.open({

						title: 'Tahun Anggaran',
						body: {
							type: 'panel',
							items: [
								{
									type: 'selectbox',
									name: 'tahun',
									label: 'Pilih Tahun Anggaran',
									items: data
								},
							]
						},
						buttons: [
							{
								type: 'cancel',
								text: 'Tutup'
							},
							{
								type: 'submit',
								text: 'Pilih',
								primary: true
							}
						],

						onSubmit: function (api) {
							var data = api.getData();
							editor.insertContent('[[lap-RP-APBD-Bidang-sm' + semester + ',' + data.tahun + ']]');
							api.close();
						},

						width: 400,
						height: 140
					})
				},

				error: function (xhr, status, error) {
					alert("Error! " + xhr.status + "\n" + error);
					console.log(xhr);
				}
			});
		}
	};
	return lap;
};


function lap_kelompok_dd(editor, semester) {
	var lap =
	{
		type: 'menuitem',
		text: 'Laporan Dana Desa (Kelompok) - Semester ' + semester,
		icon: 'table',
		onAction: function () {
			var url = BASE_URL + "index.php/keuangan/cek_tahun";

			$.ajax({
				type: "GET",
				url: url,
				dataType: "json",
				processData: true,
				success: function (data) {

					editor.windowManager.open({

						title: 'Tahun Anggaran',
						body: {
							type: 'panel',
							items: [
								{
									type: 'selectbox',
									name: 'tahun',
									label: 'Pilih Tahun Anggaran',
									items: data
								},
							]
						},
						buttons: [
							{
								type: 'cancel',
								text: 'Tutup'
							},
							{
								type: 'submit',
								text: 'Pilih',
								primary: true
							}
						],

						onSubmit: function (api) {
							var data = api.getData();
							editor.insertContent('[[lap-RP-APBD-dd-sm' + semester + ',' + data.tahun + ']]');
							api.close();
						},

						width: 400,
						height: 140
					})
				},

				error: function (xhr, status, error) {
					alert("Error! " + xhr.status + "\n" + error);
					console.log(xhr);
				}
			});
		}
	};
	return lap;
};

function lap_bidang_dd(editor, semester) {
	var lap =
	{
		type: 'menuitem',
		text: 'Laporan Dana Desa (Bidang) - Semester ' + semester,
		icon: 'table',
		onAction: function () {
			var url = BASE_URL + "index.php/keuangan/cek_tahun";

			$.ajax({
				type: "GET",
				url: url,
				dataType: "json",
				processData: true,
				success: function (data) {

					editor.windowManager.open({

						title: 'Tahun Anggaran',
						body: {
							type: 'panel',
							items: [
								{
									type: 'selectbox',
									name: 'tahun',
									label: 'Pilih Tahun Anggaran',
									items: data
								},
							]
						},
						buttons: [
							{
								type: 'cancel',
								text: 'Tutup'
							},
							{
								type: 'submit',
								text: 'Pilih',
								primary: true
							}
						],

						onSubmit: function (api) {
							var data = api.getData();
							editor.insertContent('[[lap-RP-APBD-Bidang-dd-sm' + semester + ',' + data.tahun + ']]');
							api.close();
						},

						width: 400,
						height: 140
					})
				},

				error: function (xhr, status, error) {
					alert("Error! " + xhr.status + "\n" + error);
					console.log(xhr);
				}
			});
		}
	};
	return lap;
};

tinymce.PluginManager.add('laporan_keuangan', function (editor, url) {

	editor.ui.registry.addMenuButton('laporan_keuangan', {
		text: 'Laporan Keuangan',
		fetch: function (callback) {
			var items = [];

			var menuItem = {
				type: 'nestedmenuitem',
				icon: 'link',
				text: 'Laporan Keuangan (Impor)',
				getSubmenuItems: function () {
					return [
						{
							type: 'menuitem',
							text: 'Grafik Laporan Keuangan - Impor',
							icon: 'align-left',
							onAction: function () {
								var url = BASE_URL + "index.php/keuangan/cek_tahun";

								$.ajax({
									type: "GET",
									url: url,
									dataType: "json",
									processData: true,
									success: function (data) {

										editor.windowManager.open({

											title: 'Tahun Anggaran',
											body: {
												type: 'panel',
												items: [
													{
														type: 'selectbox',
														name: 'tahun',
														label: 'Pilih Tahun Anggaran',
														items: data
													},
												]
											},
											buttons: [
												{
													type: 'cancel',
													text: 'Tutup'
												},
												{
													type: 'submit',
													text: 'Pilih',
													primary: true
												}
											],

											onSubmit: function (api) {
												var data = api.getData();
												editor.insertContent('[[grafik-RP-APBD,' + data.tahun + ']]');
												api.close();
											},

											width: 400,
											height: 140
										})
									},

									error: function (xhr, status, error) {
										alert("Error! " + xhr.status + "\n" + error);
										console.log(xhr);
									}
								});
							}
						},
						lap_kelompok(editor, '1'),
						lap_kelompok(editor, '2'),
						lap_bidang(editor, '1'),
						lap_bidang(editor, '2')
					];
				}
			};
			items.push(menuItem);

			var menuItem = {
				type: 'nestedmenuitem',
				icon: 'line',
				text: 'Laporan Keuangan (Manual)',
				getSubmenuItems: function () {
					return [

						{
							type: 'menuitem',
							text: 'Grafik Laporan Keuangan - Manual',
							icon: 'align-left',
							onAction: function () {
								var url = BASE_URL + "index.php/keuangan_manual/cek_tahun_manual";

								$.ajax({
									type: "GET",
									url: url,
									dataType: "json",
									processData: true,
									success: function (data) {

										editor.windowManager.open({

											title: 'Tahun Anggaran',
											body: {
												type: 'panel',
												items: [
													{
														type: 'selectbox',
														name: 'tahun',
														label: 'Pilih Tahun Anggaran',
														items: data
													},
												]
											},
											buttons: [
												{
													type: 'cancel',
													text: 'Tutup'
												},
												{
													type: 'submit',
													text: 'Pilih',
													primary: true
												}
											],

											onSubmit: function (api) {
												var data = api.getData();
												editor.insertContent('[[grafik-RP-APBD-manual,' + data.tahun + ']]');
												api.close();
											},

											width: 400,
											height: 140
										})
									},

									error: function (xhr, status, error) {
										alert("Error! " + xhr.status + "\n" + error);
										console.log(xhr);
									}
								});
							}
						},
						{
							type: 'menuitem',
							text: 'Laporan Keuangan (Belanja per Bidang) - Manual',
							icon: 'table',
							onAction: function () {
								var url = BASE_URL + "index.php/keuangan_manual/cek_tahun_manual";

								$.ajax({
									type: "GET",
									url: url,
									dataType: "json",
									processData: true,
									success: function (data) {

										editor.windowManager.open({

											title: 'Tahun Anggaran',
											body: {
												type: 'panel',
												items: [
													{
														type: 'selectbox',
														name: 'tahun',
														label: 'Pilih Tahun Anggaran',
														items: data
													},
												]
											},
											buttons: [
												{
													type: 'cancel',
													text: 'Tutup'
												},
												{
													type: 'submit',
													text: 'Pilih',
													primary: true
												}
											],

											onSubmit: function (api) {
												var data = api.getData();
												editor.insertContent('[[lap-RP-APBD-Bidang-manual,' + data.tahun + ']]');
												api.close();
											},

											width: 400,
											height: 140
										})
									},

									error: function (xhr, status, error) {
										alert("Error! " + xhr.status + "\n" + error);
										console.log(xhr);
									}
								});
							}
						},

					];
				}
			};
			items.push(menuItem);

			var menuItem = {
				type: 'nestedmenuitem',
				icon: 'link',
				text: 'Laporan Dana Desa',
				getSubmenuItems: function () {
					return [
						{
							type: 'menuitem',
							text: 'Grafik Laporan Dana Desa',
							icon: 'align-left',
							onAction: function () {
								var url = BASE_URL + "index.php/keuangan/cek_tahun";

								$.ajax({
									type: "GET",
									url: url,
									dataType: "json",
									processData: true,
									success: function (data) {

										editor.windowManager.open({

											title: 'Tahun Anggaran',
											body: {
												type: 'panel',
												items: [
													{
														type: 'selectbox',
														name: 'tahun',
														label: 'Pilih Tahun Anggaran',
														items: data
													},
												]
											},
											buttons: [
												{
													type: 'cancel',
													text: 'Tutup'
												},
												{
													type: 'submit',
													text: 'Pilih',
													primary: true
												}
											],

											onSubmit: function (api) {
												var data = api.getData();
												editor.insertContent('[[grafik-RP-APBD-DD,' + data.tahun + ']]');
												api.close();
											},

											width: 400,
											height: 140
										})
									},

									error: function (xhr, status, error) {
										alert("Error! " + xhr.status + "\n" + error);
										console.log(xhr);
									}
								});
							}
						},
						lap_kelompok_dd(editor, '1'),
						lap_kelompok_dd(editor, '2'),
						lap_bidang_dd(editor, '1'),
						lap_bidang_dd(editor, '2')
					];
				}
			};
			items.push(menuItem);

			callback(items);
		},
	});

});
